<?php
/*
Template Name:Blog
*/
?>
<?php get_header();

?>
<?php wp_reset_postdata(); ?>	
<div class="content-wrapper">
    	<div class="container">
    		<div class="row">
			  <?php if(!is_active_sidebar('sidebar-1')||get_field('disable_sidebar')){?>		
    			<div class="span12" id="blog-container">
				<?php } else { ?>
					<div class="span9" id="blog-container">
					<?php }?>
    				<h3><?php get_field('page_title')? the_field('page_title') :  the_title(); ?></h3>
    					<div id="items">
    						<div class="span0"></div>
							<?php									
								setup_postdata($post);	 
								$post_num  = get_field("post_on_page"); 
								$sticky = get_option( 'sticky_posts' );
								if(!is_page()){
									$post_num = get_option('posts_per_page');
								}
								$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
	                            $args1 = array(
	                                'post_type' => 'post',											
									'posts_per_page' => $post_num ,
									'post_status'      => 'any',
									'paged'     => $paged
	                            );
								
								 $the_query = new WP_Query($args1);
								 $countpost = wp_count_posts();
								
	                             while ( $the_query->have_posts() ):
	                                $the_query->the_post();
									
	                        ?>
							<script>
							var num_of_posts = "<?php echo $post_num; ?>";
							var maxNumPages = "<?php echo $the_query->max_num_pages;?>";
							if(num_of_posts <= 0) {num_of_posts = 4 ;}
							</script>							
						
				            <div class="item blog-item span3 <?php if(is_sticky()){ echo 'sticky';} ?>">
				            	<a href="<?php the_permalink()?>">
				            	<?php if(has_post_thumbnail()): ?>
	                                        <?php
												$image = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID),'home1-blog');
												echo '<img src="'. $image[0].'"/>';
	                                        ?>
	                                    <?php endif; ?>
                                </a>		
			            		<div class="blog-desc">
			            			<div class="border-container">
									<div class="comment-size-box">
										<p class="comment-number">
											<?php  echo get_comments_number($post->post_id);  ?>
										</p>
									</div>
									<div class="triangle-box">
										<div class="triangle triangle-border"></div>
										<div class="triangle triangle-body"></div>
									</div>
									</div>
									 <a href="<?php the_permalink()?>">
										<p class="post-title"><?php the_title();?></p>
										<p class="post-categoty">
										<?php 
												$post_categories = wp_get_post_categories( $post->ID );								
												$categories = '';	
												foreach($post_categories as $c){
													$cat = get_category( $c );									
													$categories = $categories.' '.$cat->name;
												}
												echo 'Posted in '.$categories;
										?></p>
												<?php $excerpt = get_the_excerpt();?>
										<p class="desc">
											<?php echo $excerpt; ?>										
										</p>
									  </a>
			            		</div>
				            </div>	
							<?php endwhile ?>		
													
			        	</div><!--div items-->
						<?php
						if(	$countpost->publish>$post_num) :?>
							<p id="load-more" class="load-more"><?php echo _e('LOAD','hybrid_lang');?> <br> <?php echo _e('MORE','hybrid_lang');?></br>...</p>
						<?php endif; ?>
				</div>
				<?php wp_reset_postdata(); ?>	
				<?php if(is_active_sidebar('sidebar-1') && !get_field('disable_sidebar')):?>	
					<div class="span3" id="blog-sidebar1">   
						<?php  if ( !function_exists('dynamic_sidebar') ||  !dynamic_sidebar('sidebar-1') ) ?>									
					</div>
				<?php endif;?>
    		</div>        	
    	</div><!--container-->
    </div><!--.content-wrapper-->
	 <div id="post-<?php the_ID(); ?>" <?php post_class(); ?> style="display:none"></div>	 
<?php get_footer();?>